/* Copyright (C) 2022 Wildfire Games.
* This file is part of 0 A.D.
*
* 0 A.D. is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* 0 A.D. is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "precompiled.h"

#include "ICmpGarrisonHolder.h"

#include "simulation2/scripting/ScriptComponent.h"
#include "simulation2/system/InterfaceScripted.h"

BEGIN_INTERFACE_WRAPPER(GarrisonHolder)
END_INTERFACE_WRAPPER(GarrisonHolder)

class CCmpGarrisonHolderScripted : public ICmpGarrisonHolder
{
public:
	DEFAULT_SCRIPT_WRAPPER(GarrisonHolderScripted)

	std::vector<entity_id_t> GetEntities() const override
	{
		return m_Script.Call<std::vector<entity_id_t>>("GetEntities");
	}

	void SetInitEntities(std::vector<entity_id_t>&& entities) override
	{
		m_Script.CallVoid("SetInitGarrison", entities);
	}
};

REGISTER_COMPONENT_SCRIPT_WRAPPER(GarrisonHolderScripted)
