/* Generated from the Telepathy spec

Copyright (C) 2005, 2006, 2007 Collabora Limited
Copyright (C) 2005, 2006, 2007 Nokia Corporation


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
*/

#include <_gen/telepathy-errors.h>

GType
tp_error_get_type (void)
{
  static GType etype = 0;
  if (G_UNLIKELY (etype == 0))
    {
      static const GEnumValue values[] = {

        /* org.freedesktop.Telepathy.Error.NETWORK_ERROR
    Raised when there is an error reading from or writing to the network.
     */
        { TP_ERROR_NETWORK_ERROR, "TP_ERROR_NETWORK_ERROR", "NetworkError" },

        /* org.freedesktop.Telepathy.Error.NOT_IMPLEMENTED
    Raised when the requested method, channel, etc is not available on this connection.
     */
        { TP_ERROR_NOT_IMPLEMENTED, "TP_ERROR_NOT_IMPLEMENTED", "NotImplemented" },

        /* org.freedesktop.Telepathy.Error.INVALID_ARGUMENT
    Raised when one of the provided arguments is invalid.
     */
        { TP_ERROR_INVALID_ARGUMENT, "TP_ERROR_INVALID_ARGUMENT", "InvalidArgument" },

        /* org.freedesktop.Telepathy.Error.NOT_AVAILABLE
    Raised when the requested functionality is temporarily unavailable.
     */
        { TP_ERROR_NOT_AVAILABLE, "TP_ERROR_NOT_AVAILABLE", "NotAvailable" },

        /* org.freedesktop.Telepathy.Error.PERMISSION_DENIED
    The user is not permitted to perform the requested operation.
     */
        { TP_ERROR_PERMISSION_DENIED, "TP_ERROR_PERMISSION_DENIED", "PermissionDenied" },

        /* org.freedesktop.Telepathy.Error.DISCONNECTED
    The connection is not currently connected and cannot be used.
     */
        { TP_ERROR_DISCONNECTED, "TP_ERROR_DISCONNECTED", "Disconnected" },

        /* org.freedesktop.Telepathy.Error.INVALID_HANDLE
    The contact name specified is unknown on this channel or connection.
     */
        { TP_ERROR_INVALID_HANDLE, "TP_ERROR_INVALID_HANDLE", "InvalidHandle" },

        /* org.freedesktop.Telepathy.Error.CHANNEL_BANNED
    You are banned from the channel.
     */
        { TP_ERROR_CHANNEL_BANNED, "TP_ERROR_CHANNEL_BANNED", "Channel.Banned" },

        /* org.freedesktop.Telepathy.Error.CHANNEL_FULL
    The channel is full.
     */
        { TP_ERROR_CHANNEL_FULL, "TP_ERROR_CHANNEL_FULL", "Channel.Full" },

        /* org.freedesktop.Telepathy.Error.CHANNEL_INVITE_ONLY
    The requested channel is invite-only.
     */
        { TP_ERROR_CHANNEL_INVITE_ONLY, "TP_ERROR_CHANNEL_INVITE_ONLY", "Channel.InviteOnly" },
      };

      etype = g_enum_register_static ("TpError", values);
    }
  return etype;
}

