/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
tp_cli_add_signals_for_connection (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "NewChannel",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRING,
      G_TYPE_UINT,
      G_TYPE_UINT,
      G_TYPE_BOOLEAN,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "StatusChanged",
      G_TYPE_UINT,
      G_TYPE_UINT,
      G_TYPE_INVALID);
}


/**
 * tp_cli_connection_signal_callback_new_channel:
 * @proxy: The proxy on which tp_cli_connection_connect_to_new_channel ()
 *  was called
 * @arg_object_path: A D-Bus object path for the channel object on this service
 * @arg_channel_type: A D-Bus interface name representing the channel type
 * @arg_handle_type: An integer representing the type of handle this channel           communicates with, or Handle_Type_None if no handle is specified
 * @arg_handle: A handle indicating the specific contact, room or list this           channel communicates with, or zero if no handle is specified
 * @arg_suppress_handler: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If true, the channel was requested by a client that intends to             present it to the user itself (i.e. it passed suppress_handler=TRUE             to the RequestChannel method), so no other handler should be             launched.&lt;/p&gt;            &lt;p&gt;If false, either the channel was created due to incoming             information from the service, or the channel was requested by             a local client that does not intend to handle the channel itself             (a typical use-case is an address-book viewer that does not itself             implement chat or VoIP functionality, starting a channel that             will be handled by the same user interface that would handle             incoming channels).&lt;/p&gt;            &lt;p&gt;Clients MUST NOT assume that only incoming channels will have             this flag set to false.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewChannel.
 */
static void
_tp_cli_connection_collect_args_of_new_channel (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_object_path,
    const gchar *arg_channel_type,
    guint arg_handle_type,
    guint arg_handle,
    gboolean arg_suppress_handler,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (5);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 5; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_object_path);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_channel_type);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, G_TYPE_UINT);
  g_value_set_uint (args->values + 2, arg_handle_type);

  g_value_unset (args->values + 3);
  g_value_init (args->values + 3, G_TYPE_UINT);
  g_value_set_uint (args->values + 3, arg_handle);

  g_value_unset (args->values + 4);
  g_value_init (args->values + 4, G_TYPE_BOOLEAN);
  g_value_set_boolean (args->values + 4, arg_suppress_handler);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_invoke_callback_for_new_channel (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_signal_callback_new_channel callback =
      (tp_cli_connection_signal_callback_new_channel) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_string (args->values + 1),
      g_value_get_uint (args->values + 2),
      g_value_get_uint (args->values + 3),
      g_value_get_boolean (args->values + 4),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_connect_to_new_channel:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewChannel.
 *
 * Emitted when a new Channel object is created, either through user         request or incoming information from the service.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_connect_to_new_channel (TpConnection *proxy,
    tp_cli_connection_signal_callback_new_channel callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[6] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRING,
      G_TYPE_UINT,
      G_TYPE_UINT,
      G_TYPE_BOOLEAN,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION, "NewChannel",
      expected_types,
      G_CALLBACK (_tp_cli_connection_collect_args_of_new_channel),
      _tp_cli_connection_invoke_callback_for_new_channel,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_signal_callback_status_changed:
 * @proxy: The proxy on which tp_cli_connection_connect_to_status_changed ()
 *  was called
 * @arg_status: An integer indicating the new status, as defined by ConnectionStatus
 * @arg_reason: An integer indicating the reason for the status change, as defined           by ConnectionStatusReason
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StatusChanged.
 */
static void
_tp_cli_connection_collect_args_of_status_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_status,
    guint arg_reason,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_status);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_UINT);
  g_value_set_uint (args->values + 1, arg_reason);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_invoke_callback_for_status_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_signal_callback_status_changed callback =
      (tp_cli_connection_signal_callback_status_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      g_value_get_uint (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_connect_to_status_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StatusChanged.
 *
 * Emitted when the status of the connection changes.  All states and         reasons have numerical values, as defined in ConnectionStatus         and ConnectionStatusReason.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_connect_to_status_changed (TpConnection *proxy,
    tp_cli_connection_signal_callback_status_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      G_TYPE_UINT,
      G_TYPE_UINT,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION, "StatusChanged",
      expected_types,
      G_CALLBACK (_tp_cli_connection_collect_args_of_status_changed),
      _tp_cli_connection_invoke_callback_for_status_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_callback_for_connect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Connect method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_connect (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_invoke_callback_connect (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_connect callback = (tp_cli_connection_callback_for_connect) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_call_connect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Connect method call.
 *
 * Request that the connection be established. This will be done         asynchronously and errors will be returned by emitting StatusChanged         signals.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_connect (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_connect callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Connect",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Connect", iface,
          _tp_cli_connection_invoke_callback_connect,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Connect",
              _tp_cli_connection_collect_callback_connect,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_connect;
static void
_tp_cli_connection_finish_running_connect (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_connect *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_run_connect:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Connect and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the connection be established. This will be done         asynchronously and errors will be returned by emitting StatusChanged         signals.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_connect (TpConnection *proxy,
    gint timeout_ms,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_connect state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "Connect", iface,
      _tp_cli_connection_finish_running_connect,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "Connect",
          _tp_cli_connection_collect_callback_connect,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_disconnect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Disconnect method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_disconnect (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_invoke_callback_disconnect (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_disconnect callback = (tp_cli_connection_callback_for_disconnect) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_call_disconnect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Disconnect method call.
 *
 * Request that the connection be closed. This closes the connection if         it&apos;s not already in DISCONNECTED state, and destroys the connection         object.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_disconnect (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_disconnect callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Disconnect",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Disconnect", iface,
          _tp_cli_connection_invoke_callback_disconnect,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Disconnect",
              _tp_cli_connection_collect_callback_disconnect,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_disconnect;
static void
_tp_cli_connection_finish_running_disconnect (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_disconnect *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_run_disconnect:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Disconnect and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the connection be closed. This closes the connection if         it&apos;s not already in DISCONNECTED state, and destroys the connection         object.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_disconnect (TpConnection *proxy,
    gint timeout_ms,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_disconnect state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "Disconnect", iface,
      _tp_cli_connection_finish_running_disconnect,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "Disconnect",
          _tp_cli_connection_collect_callback_disconnect,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_get_interfaces:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of D-Bus interface names
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetInterfaces method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_get_interfaces (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_get_interfaces (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_get_interfaces callback = (tp_cli_connection_callback_for_get_interfaces) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_get_interfaces:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetInterfaces method call.
 *
 * Get the optional interfaces supported by this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_get_interfaces (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_get_interfaces callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetInterfaces",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetInterfaces", iface,
          _tp_cli_connection_invoke_callback_get_interfaces,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetInterfaces",
              _tp_cli_connection_collect_callback_get_interfaces,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar ***out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_get_interfaces;
static void
_tp_cli_connection_finish_running_get_interfaces (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_get_interfaces *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_get_interfaces:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of D-Bus interface names
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetInterfaces and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the optional interfaces supported by this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_get_interfaces (TpConnection *proxy,
    gint timeout_ms,
    gchar ***out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_get_interfaces state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetInterfaces", iface,
      _tp_cli_connection_finish_running_get_interfaces,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetInterfaces",
          _tp_cli_connection_collect_callback_get_interfaces,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_get_protocol:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: A string identifier for the protocol
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetProtocol method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_get_protocol (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRING, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRING);
  g_value_take_string (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_get_protocol (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_get_protocol callback = (tp_cli_connection_callback_for_get_protocol) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_string (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_get_protocol:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetProtocol method call.
 *
 * Get the protocol this connection is using.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_get_protocol (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_get_protocol callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetProtocol",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetProtocol", iface,
          _tp_cli_connection_invoke_callback_get_protocol,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetProtocol",
              _tp_cli_connection_collect_callback_get_protocol,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_get_protocol;
static void
_tp_cli_connection_finish_running_get_protocol (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_get_protocol *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_string (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_get_protocol:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: A string identifier for the protocol
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetProtocol and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the protocol this connection is using.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_get_protocol (TpConnection *proxy,
    gint timeout_ms,
    gchar **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_get_protocol state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetProtocol", iface,
      _tp_cli_connection_finish_running_get_protocol,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetProtocol",
          _tp_cli_connection_collect_callback_get_protocol,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_get_self_handle:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An integer handle representing the user
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetSelfHandle method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_get_self_handle (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  guint out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_UINT, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_get_self_handle (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_get_self_handle callback = (tp_cli_connection_callback_for_get_self_handle) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          0,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_uint (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_get_self_handle:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetSelfHandle method call.
 *
 * Get the handle which represents the user on this connection, which will         remain valid for the lifetime of this connection, or until a change         in the user&apos;s identifier is signalled by the Renamed signal on the         Renaming interface (if present).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_get_self_handle (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_get_self_handle callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetSelfHandle",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetSelfHandle", iface,
          _tp_cli_connection_invoke_callback_get_self_handle,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetSelfHandle",
              _tp_cli_connection_collect_callback_get_self_handle,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    guint *out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_get_self_handle;
static void
_tp_cli_connection_finish_running_get_self_handle (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_get_self_handle *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_get_uint (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_get_self_handle:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An integer handle representing the user
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetSelfHandle and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the handle which represents the user on this connection, which will         remain valid for the lifetime of this connection, or until a change         in the user&apos;s identifier is signalled by the Renamed signal on the         Renaming interface (if present).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_get_self_handle (TpConnection *proxy,
    gint timeout_ms,
    guint *out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_get_self_handle state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetSelfHandle", iface,
      _tp_cli_connection_finish_running_get_self_handle,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetSelfHandle",
          _tp_cli_connection_collect_callback_get_self_handle,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_get_status:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An integer representing the current status
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetStatus method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_get_status (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  guint out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_UINT, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_get_status (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_get_status callback = (tp_cli_connection_callback_for_get_status) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          0,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_uint (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_get_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetStatus method call.
 *
 * Get the current status as defined in the StatusChanged signal.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_get_status (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_get_status callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetStatus",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetStatus", iface,
          _tp_cli_connection_invoke_callback_get_status,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetStatus",
              _tp_cli_connection_collect_callback_get_status,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    guint *out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_get_status;
static void
_tp_cli_connection_finish_running_get_status (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_get_status *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_get_uint (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_get_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An integer representing the current status
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the current status as defined in the StatusChanged signal.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_get_status (TpConnection *proxy,
    gint timeout_ms,
    guint *out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_get_status state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetStatus", iface,
      _tp_cli_connection_finish_running_get_status,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetStatus",
          _tp_cli_connection_collect_callback_get_status,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_hold_handles:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a HoldHandles method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_hold_handles (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_invoke_callback_hold_handles (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_hold_handles callback = (tp_cli_connection_callback_for_hold_handles) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_call_hold_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle to be held
 * @in_handles: Used to pass an 'in' argument: A array of integer handles to hold
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a HoldHandles method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Notify the connection manger that your client is holding a copy         of handles which may not be in use in any existing channel or         list, and were not obtained by using the RequestHandles method. For         example, a handle observed in an emitted signal, or displayed         somewhere in the UI that is not associated with a channel. The         connection manager must not deallocate a handle where any clients         have used this method to indicate it is in use until the ReleaseHandle         method is called, or the clients disappear from the bus.&lt;/p&gt;          &lt;p&gt;Note that HoldHandles is idempotent - calling it multiple times           is equivalent to calling it once. If a handle is &amp;quot;referenced&amp;quot; by           several components which share a D-Bus unique name, the client           should perform reference counting internally, and only call           ReleaseHandles when none of the cooperating components need the           handle any longer.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_hold_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    tp_cli_connection_callback_for_hold_handles callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "HoldHandles",
          G_TYPE_UINT, in_handle_type,
          DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "HoldHandles", iface,
          _tp_cli_connection_invoke_callback_hold_handles,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "HoldHandles",
              _tp_cli_connection_collect_callback_hold_handles,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_hold_handles;
static void
_tp_cli_connection_finish_running_hold_handles (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_hold_handles *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_run_hold_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle to be held
 * @in_handles: Used to pass an 'in' argument: A array of integer handles to hold
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method HoldHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Notify the connection manger that your client is holding a copy         of handles which may not be in use in any existing channel or         list, and were not obtained by using the RequestHandles method. For         example, a handle observed in an emitted signal, or displayed         somewhere in the UI that is not associated with a channel. The         connection manager must not deallocate a handle where any clients         have used this method to indicate it is in use until the ReleaseHandle         method is called, or the clients disappear from the bus.&lt;/p&gt;          &lt;p&gt;Note that HoldHandles is idempotent - calling it multiple times           is equivalent to calling it once. If a handle is &amp;quot;referenced&amp;quot; by           several components which share a D-Bus unique name, the client           should perform reference counting internally, and only call           ReleaseHandles when none of the cooperating components need the           handle any longer.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_hold_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_hold_handles state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "HoldHandles", iface,
      _tp_cli_connection_finish_running_hold_handles,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "HoldHandles",
          _tp_cli_connection_collect_callback_hold_handles,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_inspect_handles:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of handle names in the same order as the given numbers
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a InspectHandles method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_inspect_handles (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_inspect_handles (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_inspect_handles callback = (tp_cli_connection_callback_for_inspect_handles) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_inspect_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle to be inspected
 * @in_handles: Used to pass an 'in' argument: An array of integer handles of this type
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a InspectHandles method call.
 *
 * Return a string representation for a number of handles of a given         type.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_inspect_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    tp_cli_connection_callback_for_inspect_handles callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "InspectHandles",
          G_TYPE_UINT, in_handle_type,
          DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "InspectHandles", iface,
          _tp_cli_connection_invoke_callback_inspect_handles,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "InspectHandles",
              _tp_cli_connection_collect_callback_inspect_handles,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar ***out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_inspect_handles;
static void
_tp_cli_connection_finish_running_inspect_handles (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_inspect_handles *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_inspect_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle to be inspected
 * @in_handles: Used to pass an 'in' argument: An array of integer handles of this type
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of handle names in the same order as the given numbers
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method InspectHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return a string representation for a number of handles of a given         type.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_inspect_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    gchar ***out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_inspect_handles state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "InspectHandles", iface,
      _tp_cli_connection_finish_running_inspect_handles,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "InspectHandles",
          _tp_cli_connection_collect_callback_inspect_handles,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_list_channels:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of structs representing channels.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListChannels method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_list_channels (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GPtrArray *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))), &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_list_channels (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_list_channels callback = (tp_cli_connection_callback_for_list_channels) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_list_channels:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListChannels method call.
 *
 * List all the channels which currently exist on this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_list_channels (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_callback_for_list_channels callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "ListChannels",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "ListChannels", iface,
          _tp_cli_connection_invoke_callback_list_channels,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "ListChannels",
              _tp_cli_connection_collect_callback_list_channels,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GPtrArray **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_list_channels;
static void
_tp_cli_connection_finish_running_list_channels (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_list_channels *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_list_channels:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of structs representing channels.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListChannels and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * List all the channels which currently exist on this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_list_channels (TpConnection *proxy,
    gint timeout_ms,
    GPtrArray **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_list_channels state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "ListChannels", iface,
      _tp_cli_connection_finish_running_list_channels,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "ListChannels",
          _tp_cli_connection_collect_callback_list_channels,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_release_handles:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ReleaseHandles method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_release_handles (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_invoke_callback_release_handles (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_release_handles callback = (tp_cli_connection_callback_for_release_handles) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_call_release_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handle_type: Used to pass an 'in' argument: An integer handle type (as defined in RequestHandle)
 * @in_handles: Used to pass an 'in' argument: An array of integer handles being held by the client
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ReleaseHandles method call.
 *
 * Explicitly notify the connection manager that your client is no         longer holding any references to the given handles, and that they         may be deallocated if they are not held by any other clients or         referenced by any existing channels. See HoldHandles for notes.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_release_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    tp_cli_connection_callback_for_release_handles callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "ReleaseHandles",
          G_TYPE_UINT, in_handle_type,
          DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "ReleaseHandles", iface,
          _tp_cli_connection_invoke_callback_release_handles,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "ReleaseHandles",
              _tp_cli_connection_collect_callback_release_handles,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_release_handles;
static void
_tp_cli_connection_finish_running_release_handles (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_release_handles *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_run_release_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_handle_type: Used to pass an 'in' argument: An integer handle type (as defined in RequestHandle)
 * @in_handles: Used to pass an 'in' argument: An array of integer handles being held by the client
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ReleaseHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Explicitly notify the connection manager that your client is no         longer holding any references to the given handles, and that they         may be deallocated if they are not held by any other clients or         referenced by any existing channels. See HoldHandles for notes.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_release_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const GArray *in_handles,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_release_handles state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "ReleaseHandles", iface,
      _tp_cli_connection_finish_running_release_handles,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "ReleaseHandles",
          _tp_cli_connection_collect_callback_release_handles,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_handle_type,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_request_channel:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: The D-Bus object path for the channel created or retrieved
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestChannel method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_request_channel (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      DBUS_TYPE_G_OBJECT_PATH, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_request_channel (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_request_channel callback = (tp_cli_connection_callback_for_request_channel) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_request_channel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_type: Used to pass an 'in' argument: A D-Bus interface name representing base channel type
 * @in_handle_type: Used to pass an 'in' argument: An integer representing the handle type, or Handle_Type_None if           no handle is specified
 * @in_handle: Used to pass an 'in' argument: A nonzero integer handle representing a contact, room, list etc.           according to handle_type, or zero if the handle_type is           Handle_Type_None
 * @in_suppress_handler: Used to pass an 'in' argument: If true, the requesting client intends to take responsibility for           displaying the channel to the user, so no other handler needs to           be launched
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestChannel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a channel satisfying the specified type and communicating           with the contact, room, list etc. indicated by the given           handle_type and handle. The handle_type and handle may both be           zero to request the creation of a new, empty channel, which may           or may not be possible, depending on the protocol and channel           type.&lt;/p&gt;          &lt;p&gt;On success, the returned channel will always be of the requested           type (i.e. implement the requested channel-type interface).&lt;/p&gt;          &lt;p&gt;If a new, empty channel is requested, on success the returned           channel will always be an &amp;quot;anonymous&amp;quot; channel for which the type           and handle are both zero.&lt;/p&gt;          &lt;p&gt;If a channel to a contact, room etc. is requested, on success, the           returned channel may either be a new or existing channel to           the requested entity (i.e. its GetHandle() returns the           requested handle type and handle), or a newly created &amp;quot;anonymous&amp;quot;           channel associated with the requested handle in some           implementation-specific way.&lt;/p&gt;          &lt;p&gt;For example, for a contact handle, the returned channel           might be &amp;quot;anonymous&amp;quot;, but implement the groups interface and have           the requested contact already present among the members.&lt;/p&gt;          &lt;p&gt;If the request cannot be satisfied, an error is raised and no           channel is created.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_request_channel (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_type,
    guint in_handle_type,
    guint in_handle,
    gboolean in_suppress_handler,
    tp_cli_connection_callback_for_request_channel callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestChannel",
          G_TYPE_STRING, in_type,
          G_TYPE_UINT, in_handle_type,
          G_TYPE_UINT, in_handle,
          G_TYPE_BOOLEAN, in_suppress_handler,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestChannel", iface,
          _tp_cli_connection_invoke_callback_request_channel,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestChannel",
              _tp_cli_connection_collect_callback_request_channel,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_STRING, in_type,
              G_TYPE_UINT, in_handle_type,
              G_TYPE_UINT, in_handle,
              G_TYPE_BOOLEAN, in_suppress_handler,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_request_channel;
static void
_tp_cli_connection_finish_running_request_channel (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_request_channel *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_request_channel:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_type: Used to pass an 'in' argument: A D-Bus interface name representing base channel type
 * @in_handle_type: Used to pass an 'in' argument: An integer representing the handle type, or Handle_Type_None if           no handle is specified
 * @in_handle: Used to pass an 'in' argument: A nonzero integer handle representing a contact, room, list etc.           according to handle_type, or zero if the handle_type is           Handle_Type_None
 * @in_suppress_handler: Used to pass an 'in' argument: If true, the requesting client intends to take responsibility for           displaying the channel to the user, so no other handler needs to           be launched
 * @out0: Used to return an 'out' argument if %TRUE is returned: The D-Bus object path for the channel created or retrieved
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestChannel and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a channel satisfying the specified type and communicating           with the contact, room, list etc. indicated by the given           handle_type and handle. The handle_type and handle may both be           zero to request the creation of a new, empty channel, which may           or may not be possible, depending on the protocol and channel           type.&lt;/p&gt;          &lt;p&gt;On success, the returned channel will always be of the requested           type (i.e. implement the requested channel-type interface).&lt;/p&gt;          &lt;p&gt;If a new, empty channel is requested, on success the returned           channel will always be an &amp;quot;anonymous&amp;quot; channel for which the type           and handle are both zero.&lt;/p&gt;          &lt;p&gt;If a channel to a contact, room etc. is requested, on success, the           returned channel may either be a new or existing channel to           the requested entity (i.e. its GetHandle() returns the           requested handle type and handle), or a newly created &amp;quot;anonymous&amp;quot;           channel associated with the requested handle in some           implementation-specific way.&lt;/p&gt;          &lt;p&gt;For example, for a contact handle, the returned channel           might be &amp;quot;anonymous&amp;quot;, but implement the groups interface and have           the requested contact already present among the members.&lt;/p&gt;          &lt;p&gt;If the request cannot be satisfied, an error is raised and no           channel is created.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_request_channel (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_type,
    guint in_handle_type,
    guint in_handle,
    gboolean in_suppress_handler,
    gchar **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_request_channel state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestChannel", iface,
      _tp_cli_connection_finish_running_request_channel,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestChannel",
          _tp_cli_connection_collect_callback_request_channel,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_STRING, in_type,
              G_TYPE_UINT, in_handle_type,
              G_TYPE_UINT, in_handle,
              G_TYPE_BOOLEAN, in_suppress_handler,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_callback_for_request_handles:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of integer handle numbers in the same order as the given strings
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestHandles method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_collect_callback_request_handles (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GArray *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      DBUS_TYPE_G_UINT_ARRAY, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_UINT_ARRAY);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_invoke_callback_request_handles (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_callback_for_request_handles callback = (tp_cli_connection_callback_for_request_handles) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_call_request_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle required
 * @in_names: Used to pass an 'in' argument: An array of names of entities to request handles for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestHandles method call.
 *
 * Request several handles from the connection manager which represent a         number of contacts, rooms or server-stored lists on the service. The         connection manager should record that these handles are in use by the         client who invokes this method, and must not deallocate the handles         until the client disconnects from the bus or calls the ReleaseHandle         method. Where the name refers to an entity that already has a handle         in this connection manager, this handle should be returned instead.         The handle number 0 must not be returned by the connection manager.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_call_request_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const gchar **in_names,
    tp_cli_connection_callback_for_request_handles callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestHandles",
          G_TYPE_UINT, in_handle_type,
          G_TYPE_STRV, in_names,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestHandles", iface,
          _tp_cli_connection_invoke_callback_request_handles,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestHandles",
              _tp_cli_connection_collect_callback_request_handles,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_handle_type,
              G_TYPE_STRV, in_names,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GArray **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_run_state_request_handles;
static void
_tp_cli_connection_finish_running_request_handles (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_run_state_request_handles *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_run_request_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_handle_type: Used to pass an 'in' argument: The type of handle required
 * @in_names: Used to pass an 'in' argument: An array of names of entities to request handles for
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of integer handle numbers in the same order as the given strings
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request several handles from the connection manager which represent a         number of contacts, rooms or server-stored lists on the service. The         connection manager should record that these handles are in use by the         client who invokes this method, and must not deallocate the handles         until the client disconnects from the bus or calls the ReleaseHandle         method. Where the name refers to an entity that already has a handle         in this connection manager, this handle should be returned instead.         The handle number 0 must not be returned by the connection manager.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_run_request_handles (TpConnection *proxy,
    gint timeout_ms,
    guint in_handle_type,
    const gchar **in_names,
    GArray **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION;
  TpProxyPendingCall *pc;
  _tp_cli_connection_run_state_request_handles state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestHandles", iface,
      _tp_cli_connection_finish_running_request_handles,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestHandles",
          _tp_cli_connection_collect_callback_request_handles,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_handle_type,
              G_TYPE_STRV, in_names,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


static inline void
tp_cli_add_signals_for_connection_interface_aliasing (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "AliasesChanged",
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)))),
      G_TYPE_INVALID);
}


/**
 * tp_cli_connection_interface_aliasing_signal_callback_aliases_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_aliasing_connect_to_aliases_changed ()
 *  was called
 * @arg_aliases: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array containing structs of:           &lt;ul&gt;             &lt;li&gt;the handle representing the contact&lt;/li&gt;             &lt;li&gt;the new alias&lt;/li&gt;           &lt;/ul&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AliasesChanged.
 */
static void
_tp_cli_connection_interface_aliasing_collect_args_of_aliases_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    const GPtrArray *arg_aliases,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)))));
  g_value_set_boxed (args->values + 0, arg_aliases);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_interface_aliasing_invoke_callback_for_aliases_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_aliasing_signal_callback_aliases_changed callback =
      (tp_cli_connection_interface_aliasing_signal_callback_aliases_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_interface_aliasing_connect_to_aliases_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AliasesChanged.
 *
 * Signal emitted when a contact&apos;s alias (or that of the user) is changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_interface_aliasing_connect_to_aliases_changed (TpConnection *proxy,
    tp_cli_connection_interface_aliasing_signal_callback_aliases_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)))),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING, "AliasesChanged",
      expected_types,
      G_CALLBACK (_tp_cli_connection_interface_aliasing_collect_args_of_aliases_changed),
      _tp_cli_connection_interface_aliasing_invoke_callback_for_aliases_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_interface_aliasing_callback_for_get_alias_flags:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An integer with a bitwise OR of flags from ConnectionAliasFlags
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAliasFlags method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_aliasing_collect_callback_get_alias_flags (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  guint out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_UINT, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_aliasing_invoke_callback_get_alias_flags (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_aliasing_callback_for_get_alias_flags callback = (tp_cli_connection_interface_aliasing_callback_for_get_alias_flags) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          0,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_uint (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_call_get_alias_flags:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAliasFlags method call.
 *
 * Return a bitwise OR of flags detailing the behaviour of aliases on this         connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_aliasing_call_get_alias_flags (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_interface_aliasing_callback_for_get_alias_flags callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetAliasFlags",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetAliasFlags", iface,
          _tp_cli_connection_interface_aliasing_invoke_callback_get_alias_flags,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetAliasFlags",
              _tp_cli_connection_interface_aliasing_collect_callback_get_alias_flags,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    guint *out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_aliasing_run_state_get_alias_flags;
static void
_tp_cli_connection_interface_aliasing_finish_running_get_alias_flags (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_aliasing_run_state_get_alias_flags *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_get_uint (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_run_get_alias_flags:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An integer with a bitwise OR of flags from ConnectionAliasFlags
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAliasFlags and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return a bitwise OR of flags detailing the behaviour of aliases on this         connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_aliasing_run_get_alias_flags (TpConnection *proxy,
    gint timeout_ms,
    guint *out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_aliasing_run_state_get_alias_flags state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetAliasFlags", iface,
      _tp_cli_connection_interface_aliasing_finish_running_get_alias_flags,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetAliasFlags",
          _tp_cli_connection_interface_aliasing_collect_callback_get_alias_flags,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_aliasing_callback_for_request_aliases:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: A list of aliases in the same order as the contact handles
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAliases method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_aliasing_collect_callback_request_aliases (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_aliasing_invoke_callback_request_aliases (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_aliasing_callback_for_request_aliases callback = (tp_cli_connection_interface_aliasing_callback_for_request_aliases) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_call_request_aliases:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAliases method call.
 *
 * Request the value of several contacts&apos; aliases at once.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_aliasing_call_request_aliases (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_aliasing_callback_for_request_aliases callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestAliases",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestAliases", iface,
          _tp_cli_connection_interface_aliasing_invoke_callback_request_aliases,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestAliases",
              _tp_cli_connection_interface_aliasing_collect_callback_request_aliases,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar ***out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_aliasing_run_state_request_aliases;
static void
_tp_cli_connection_interface_aliasing_finish_running_request_aliases (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_aliasing_run_state_request_aliases *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_run_request_aliases:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out0: Used to return an 'out' argument if %TRUE is returned: A list of aliases in the same order as the contact handles
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAliases and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the value of several contacts&apos; aliases at once.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_aliasing_run_request_aliases (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    gchar ***out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_aliasing_run_state_request_aliases state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestAliases", iface,
      _tp_cli_connection_interface_aliasing_finish_running_request_aliases,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestAliases",
          _tp_cli_connection_interface_aliasing_collect_callback_request_aliases,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_aliasing_callback_for_set_aliases:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetAliases method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_aliasing_collect_callback_set_aliases (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_aliasing_invoke_callback_set_aliases (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_aliasing_callback_for_set_aliases callback = (tp_cli_connection_interface_aliasing_callback_for_set_aliases) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_call_set_aliases:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_aliases: Used to pass an 'in' argument: A dictionary mapping integer handles of contacts           to strings of the new alias to set.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetAliases method call.
 *
 * Request that the alias of the given contact be changed. Success will be         indicated by emitting an AliasesChanged signal. On connections where the         CONNECTION_ALIAS_FLAG_USER_SET flag is not set, this method will only         ever succeed if the contact is the user&apos;s own handle (as returned by         GetSelfHandle on the Connection interface).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_aliasing_call_set_aliases (TpConnection *proxy,
    gint timeout_ms,
    GHashTable *in_aliases,
    tp_cli_connection_interface_aliasing_callback_for_set_aliases callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetAliases",
          (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_STRING)), in_aliases,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetAliases", iface,
          _tp_cli_connection_interface_aliasing_invoke_callback_set_aliases,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetAliases",
              _tp_cli_connection_interface_aliasing_collect_callback_set_aliases,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_STRING)), in_aliases,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_aliasing_run_state_set_aliases;
static void
_tp_cli_connection_interface_aliasing_finish_running_set_aliases (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_aliasing_run_state_set_aliases *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_aliasing_run_set_aliases:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_aliases: Used to pass an 'in' argument: A dictionary mapping integer handles of contacts           to strings of the new alias to set.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetAliases and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the alias of the given contact be changed. Success will be         indicated by emitting an AliasesChanged signal. On connections where the         CONNECTION_ALIAS_FLAG_USER_SET flag is not set, this method will only         ever succeed if the contact is the user&apos;s own handle (as returned by         GetSelfHandle on the Connection interface).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_aliasing_run_set_aliases (TpConnection *proxy,
    gint timeout_ms,
    GHashTable *in_aliases,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_aliasing_run_state_set_aliases state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "SetAliases", iface,
      _tp_cli_connection_interface_aliasing_finish_running_set_aliases,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "SetAliases",
          _tp_cli_connection_interface_aliasing_collect_callback_set_aliases,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_STRING)), in_aliases,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


static inline void
tp_cli_add_signals_for_connection_interface_avatars (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "AvatarUpdated",
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "AvatarRetrieved",
      G_TYPE_UINT,
      G_TYPE_STRING,
      dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR),
      G_TYPE_STRING,
      G_TYPE_INVALID);
}


/**
 * tp_cli_connection_interface_avatars_signal_callback_avatar_updated:
 * @proxy: The proxy on which tp_cli_connection_interface_avatars_connect_to_avatar_updated ()
 *  was called
 * @arg_contact: An integer handle for the contact whose avatar has changed
 * @arg_new_avatar_token: Unique token for their new avatar
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarUpdated.
 */
static void
_tp_cli_connection_interface_avatars_collect_args_of_avatar_updated (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_contact,
    const gchar *arg_new_avatar_token,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_contact);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_new_avatar_token);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_for_avatar_updated (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_signal_callback_avatar_updated callback =
      (tp_cli_connection_interface_avatars_signal_callback_avatar_updated) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      g_value_get_string (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_interface_avatars_connect_to_avatar_updated:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarUpdated.
 *
 * Emitted when the avatar for a contact has been updated, or first         discovered on this connection. If the token differs from the token         associated with the client&apos;s cached avatar for this contact, the new         avatar should be requested with RequestAvatars.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_interface_avatars_connect_to_avatar_updated (TpConnection *proxy,
    tp_cli_connection_interface_avatars_signal_callback_avatar_updated callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS, "AvatarUpdated",
      expected_types,
      G_CALLBACK (_tp_cli_connection_interface_avatars_collect_args_of_avatar_updated),
      _tp_cli_connection_interface_avatars_invoke_callback_for_avatar_updated,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_interface_avatars_signal_callback_avatar_retrieved:
 * @proxy: The proxy on which tp_cli_connection_interface_avatars_connect_to_avatar_retrieved ()
 *  was called
 * @arg_contact: The contact whose avatar has been retrieved
 * @arg_token: The token corresponding to the avatar
 * @arg_avatar: An array of bytes containing the image data
 * @arg_type: A string containing the image MIME type (eg image/jpeg), or empty if           unknown
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarRetrieved.
 */
static void
_tp_cli_connection_interface_avatars_collect_args_of_avatar_retrieved (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_contact,
    const gchar *arg_token,
    const GArray *arg_avatar,
    const gchar *arg_type,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (4);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 4; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_contact);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_token);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR));
  g_value_set_boxed (args->values + 2, arg_avatar);

  g_value_unset (args->values + 3);
  g_value_init (args->values + 3, G_TYPE_STRING);
  g_value_set_string (args->values + 3, arg_type);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_for_avatar_retrieved (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_signal_callback_avatar_retrieved callback =
      (tp_cli_connection_interface_avatars_signal_callback_avatar_retrieved) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      g_value_get_string (args->values + 1),
      g_value_get_boxed (args->values + 2),
      g_value_get_string (args->values + 3),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_interface_avatars_connect_to_avatar_retrieved:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarRetrieved.
 *
 * Emitted when the avatar for a contact has been retrieved.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_interface_avatars_connect_to_avatar_retrieved (TpConnection *proxy,
    tp_cli_connection_interface_avatars_signal_callback_avatar_retrieved callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[5] = {
      G_TYPE_UINT,
      G_TYPE_STRING,
      dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR),
      G_TYPE_STRING,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS, "AvatarRetrieved",
      expected_types,
      G_CALLBACK (_tp_cli_connection_interface_avatars_collect_args_of_avatar_retrieved),
      _tp_cli_connection_interface_avatars_invoke_callback_for_avatar_retrieved,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_interface_avatars_callback_for_get_avatar_requirements:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of supported MIME types (eg image/jpeg)
 * @out1: Used to return an 'out' argument if @error is %NULL: The minimum image width in pixels
 * @out2: Used to return an 'out' argument if @error is %NULL: The minimum image height in pixels
 * @out3: Used to return an 'out' argument if @error is %NULL: The maximum image width in pixels, or 0 if there is no limit
 * @out4: Used to return an 'out' argument if @error is %NULL: The maximum image height in pixels, or 0 if there is no limit
 * @out5: Used to return an 'out' argument if @error is %NULL: The maximum image size in bytes, or 0 if there is no limit
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvatarRequirements method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_get_avatar_requirements (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out0;
  guint out1;
  guint out2;
  guint out3;
  guint out4;
  guint out5;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out0,
      G_TYPE_UINT, &out1,
      G_TYPE_UINT, &out2,
      G_TYPE_UINT, &out3,
      G_TYPE_UINT, &out4,
      G_TYPE_UINT, &out5,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (6);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 6; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out0);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_UINT);
  g_value_set_uint (args->values + 1, out1);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, G_TYPE_UINT);
  g_value_set_uint (args->values + 2, out2);

  g_value_unset (args->values + 3);
  g_value_init (args->values + 3, G_TYPE_UINT);
  g_value_set_uint (args->values + 3, out3);

  g_value_unset (args->values + 4);
  g_value_init (args->values + 4, G_TYPE_UINT);
  g_value_set_uint (args->values + 4, out4);

  g_value_unset (args->values + 5);
  g_value_init (args->values + 5, G_TYPE_UINT);
  g_value_set_uint (args->values + 5, out5);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_get_avatar_requirements (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_get_avatar_requirements callback = (tp_cli_connection_interface_avatars_callback_for_get_avatar_requirements) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          0,
          0,
          0,
          0,
          0,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      g_value_get_uint (args->values + 1),
      g_value_get_uint (args->values + 2),
      g_value_get_uint (args->values + 3),
      g_value_get_uint (args->values + 4),
      g_value_get_uint (args->values + 5),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_get_avatar_requirements:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvatarRequirements method call.
 *
 * Get the required format of avatars on this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_get_avatar_requirements (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_interface_avatars_callback_for_get_avatar_requirements callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            0,
            0,
            0,
            0,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetAvatarRequirements",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetAvatarRequirements", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_get_avatar_requirements,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetAvatarRequirements",
              _tp_cli_connection_interface_avatars_collect_callback_get_avatar_requirements,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar ***out0;
    guint *out1;
    guint *out2;
    guint *out3;
    guint *out4;
    guint *out5;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_get_avatar_requirements;
static void
_tp_cli_connection_interface_avatars_finish_running_get_avatar_requirements (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_get_avatar_requirements *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  if (state->out1 != NULL)
    *state->out1 = g_value_get_uint (args->values + 1);

  if (state->out2 != NULL)
    *state->out2 = g_value_get_uint (args->values + 2);

  if (state->out3 != NULL)
    *state->out3 = g_value_get_uint (args->values + 3);

  if (state->out4 != NULL)
    *state->out4 = g_value_get_uint (args->values + 4);

  if (state->out5 != NULL)
    *state->out5 = g_value_get_uint (args->values + 5);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_get_avatar_requirements:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of supported MIME types (eg image/jpeg)
 * @out1: Used to return an 'out' argument if %TRUE is returned: The minimum image width in pixels
 * @out2: Used to return an 'out' argument if %TRUE is returned: The minimum image height in pixels
 * @out3: Used to return an 'out' argument if %TRUE is returned: The maximum image width in pixels, or 0 if there is no limit
 * @out4: Used to return an 'out' argument if %TRUE is returned: The maximum image height in pixels, or 0 if there is no limit
 * @out5: Used to return an 'out' argument if %TRUE is returned: The maximum image size in bytes, or 0 if there is no limit
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvatarRequirements and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the required format of avatars on this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_get_avatar_requirements (TpConnection *proxy,
    gint timeout_ms,
    gchar ***out0,
    guint *out1,
    guint *out2,
    guint *out3,
    guint *out4,
    guint *out5,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_get_avatar_requirements state = {
      NULL /* loop */, error,
    out0,
    out1,
    out2,
    out3,
    out4,
    out5,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetAvatarRequirements", iface,
      _tp_cli_connection_interface_avatars_finish_running_get_avatar_requirements,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetAvatarRequirements",
          _tp_cli_connection_interface_avatars_collect_callback_get_avatar_requirements,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_get_avatar_tokens:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of avatar tokens or empty strings (if no avatar is set) in the           same order as the given array of contact handles
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvatarTokens method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_get_avatar_tokens (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_get_avatar_tokens (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_get_avatar_tokens callback = (tp_cli_connection_interface_avatars_callback_for_get_avatar_tokens) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_get_avatar_tokens:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvatarTokens method call.
 *
 * Get the unique tokens for all of the given contacts&apos; avatars.          Using this method in new Telepathy clients is deprecated; use         GetKnownAvatarTokens instead.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_get_avatar_tokens (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_avatars_callback_for_get_avatar_tokens callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetAvatarTokens",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetAvatarTokens", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_get_avatar_tokens,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetAvatarTokens",
              _tp_cli_connection_interface_avatars_collect_callback_get_avatar_tokens,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar ***out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_get_avatar_tokens;
static void
_tp_cli_connection_interface_avatars_finish_running_get_avatar_tokens (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_get_avatar_tokens *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_get_avatar_tokens:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of avatar tokens or empty strings (if no avatar is set) in the           same order as the given array of contact handles
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvatarTokens and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the unique tokens for all of the given contacts&apos; avatars.          Using this method in new Telepathy clients is deprecated; use         GetKnownAvatarTokens instead.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_get_avatar_tokens (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    gchar ***out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_get_avatar_tokens state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetAvatarTokens", iface,
      _tp_cli_connection_interface_avatars_finish_running_get_avatar_tokens,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetAvatarTokens",
          _tp_cli_connection_interface_avatars_collect_callback_get_avatar_tokens,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_get_known_avatar_tokens:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: A dictionary of handles mapped to avatar tokens, containing only           the known avatar tokens.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetKnownAvatarTokens method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_get_known_avatar_tokens (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GHashTable *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_STRING)), &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_STRING)));
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_get_known_avatar_tokens (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_get_known_avatar_tokens callback = (tp_cli_connection_interface_avatars_callback_for_get_known_avatar_tokens) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_get_known_avatar_tokens:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetKnownAvatarTokens method call.
 *
 * Get the unique tokens for the given contacts&apos; avatars. These tokens         can be persisted across connections, and should be used by the client         to check whether the avatars have been updated.  A CM must always have         the tokens for the self handle if one is set (even if it is set to no         avatar). Otherwise, only tokens that are already known are returned. An         empty token means the given contact has no avatar.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_get_known_avatar_tokens (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_avatars_callback_for_get_known_avatar_tokens callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetKnownAvatarTokens",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetKnownAvatarTokens", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_get_known_avatar_tokens,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetKnownAvatarTokens",
              _tp_cli_connection_interface_avatars_collect_callback_get_known_avatar_tokens,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GHashTable **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_get_known_avatar_tokens;
static void
_tp_cli_connection_interface_avatars_finish_running_get_known_avatar_tokens (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_get_known_avatar_tokens *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_get_known_avatar_tokens:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out0: Used to return an 'out' argument if %TRUE is returned: A dictionary of handles mapped to avatar tokens, containing only           the known avatar tokens.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetKnownAvatarTokens and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the unique tokens for the given contacts&apos; avatars. These tokens         can be persisted across connections, and should be used by the client         to check whether the avatars have been updated.  A CM must always have         the tokens for the self handle if one is set (even if it is set to no         avatar). Otherwise, only tokens that are already known are returned. An         empty token means the given contact has no avatar.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_get_known_avatar_tokens (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    GHashTable **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_get_known_avatar_tokens state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetKnownAvatarTokens", iface,
      _tp_cli_connection_interface_avatars_finish_running_get_known_avatar_tokens,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetKnownAvatarTokens",
          _tp_cli_connection_interface_avatars_collect_callback_get_known_avatar_tokens,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_request_avatar:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of bytes containing the image data
 * @out1: Used to return an 'out' argument if @error is %NULL: A string containing the image MIME type (eg image/jpeg), or empty if         unknown
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAvatar method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_request_avatar (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GArray *out0;
  gchar *out1;

  dbus_g_proxy_end_call (proxy, call, &error,
      dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR), &out0,
      G_TYPE_STRING, &out1,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (2);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR));
  g_value_take_boxed (args->values + 0, out0);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_take_string (args->values + 1, out1);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_request_avatar (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_request_avatar callback = (tp_cli_connection_interface_avatars_callback_for_request_avatar) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      g_value_get_string (args->values + 1),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_request_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contact: Used to pass an 'in' argument: An integer handle for the contact to request the avatar for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAvatar method call.
 *
 * Request the avatar for a given contact. Using this method in new         Telepathy clients is deprecated; use RequestAvatars instead.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_request_avatar (TpConnection *proxy,
    gint timeout_ms,
    guint in_contact,
    tp_cli_connection_interface_avatars_callback_for_request_avatar callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestAvatar",
          G_TYPE_UINT, in_contact,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestAvatar", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_request_avatar,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestAvatar",
              _tp_cli_connection_interface_avatars_collect_callback_request_avatar,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_contact,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GArray **out0;
    gchar **out1;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_request_avatar;
static void
_tp_cli_connection_interface_avatars_finish_running_request_avatar (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_request_avatar *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  if (state->out1 != NULL)
    *state->out1 = g_value_dup_string (args->values + 1);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_request_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contact: Used to pass an 'in' argument: An integer handle for the contact to request the avatar for
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of bytes containing the image data
 * @out1: Used to return an 'out' argument if %TRUE is returned: A string containing the image MIME type (eg image/jpeg), or empty if         unknown
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the avatar for a given contact. Using this method in new         Telepathy clients is deprecated; use RequestAvatars instead.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_request_avatar (TpConnection *proxy,
    gint timeout_ms,
    guint in_contact,
    GArray **out0,
    gchar **out1,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_request_avatar state = {
      NULL /* loop */, error,
    out0,
    out1,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestAvatar", iface,
      _tp_cli_connection_interface_avatars_finish_running_request_avatar,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestAvatar",
          _tp_cli_connection_interface_avatars_collect_callback_request_avatar,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_contact,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_request_avatars:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAvatars method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_request_avatars (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_request_avatars (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_request_avatars callback = (tp_cli_connection_interface_avatars_callback_for_request_avatars) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_request_avatars:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: The contacts to retrieve avatars for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAvatars method call.
 *
 * Request avatars for a number of contacts. The AvatarRetrieved signal         is emitted for each avatar retrieved. If the handles are valid but         retrieving an avatar fails (for any reason, including the contact not         having an avatar) the AvatarRetrieved signal is not emitted for that         contact.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_request_avatars (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_avatars_callback_for_request_avatars callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestAvatars",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestAvatars", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_request_avatars,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestAvatars",
              _tp_cli_connection_interface_avatars_collect_callback_request_avatars,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_request_avatars;
static void
_tp_cli_connection_interface_avatars_finish_running_request_avatars (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_request_avatars *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_request_avatars:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: The contacts to retrieve avatars for
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAvatars and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request avatars for a number of contacts. The AvatarRetrieved signal         is emitted for each avatar retrieved. If the handles are valid but         retrieving an avatar fails (for any reason, including the contact not         having an avatar) the AvatarRetrieved signal is not emitted for that         contact.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_request_avatars (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_request_avatars state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestAvatars", iface,
      _tp_cli_connection_interface_avatars_finish_running_request_avatars,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestAvatars",
          _tp_cli_connection_interface_avatars_collect_callback_request_avatars,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_set_avatar:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: The string token of the new avatar
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetAvatar method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_set_avatar (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRING, &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRING);
  g_value_take_string (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_set_avatar (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_set_avatar callback = (tp_cli_connection_interface_avatars_callback_for_set_avatar) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_string (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_set_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_avatar: Used to pass an 'in' argument: An array of bytes representing the avatar image data
 * @in_mime_type: Used to pass an 'in' argument: A string representing the image MIME type
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetAvatar method call.
 *
 * Set a new avatar image for this connection. The avatar image must         respect the requirements obtained by GetAvatarRequirements.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_set_avatar (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_avatar,
    const gchar *in_mime_type,
    tp_cli_connection_interface_avatars_callback_for_set_avatar callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetAvatar",
          dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR), in_avatar,
          G_TYPE_STRING, in_mime_type,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetAvatar", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_set_avatar,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetAvatar",
              _tp_cli_connection_interface_avatars_collect_callback_set_avatar,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR), in_avatar,
              G_TYPE_STRING, in_mime_type,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gchar **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_set_avatar;
static void
_tp_cli_connection_interface_avatars_finish_running_set_avatar (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_set_avatar *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_string (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_set_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_avatar: Used to pass an 'in' argument: An array of bytes representing the avatar image data
 * @in_mime_type: Used to pass an 'in' argument: A string representing the image MIME type
 * @out0: Used to return an 'out' argument if %TRUE is returned: The string token of the new avatar
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Set a new avatar image for this connection. The avatar image must         respect the requirements obtained by GetAvatarRequirements.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_set_avatar (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_avatar,
    const gchar *in_mime_type,
    gchar **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_set_avatar state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "SetAvatar", iface,
      _tp_cli_connection_interface_avatars_finish_running_set_avatar,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "SetAvatar",
          _tp_cli_connection_interface_avatars_collect_callback_set_avatar,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR), in_avatar,
              G_TYPE_STRING, in_mime_type,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_avatars_callback_for_clear_avatar:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ClearAvatar method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_avatars_collect_callback_clear_avatar (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_avatars_invoke_callback_clear_avatar (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_avatars_callback_for_clear_avatar callback = (tp_cli_connection_interface_avatars_callback_for_clear_avatar) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_call_clear_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ClearAvatar method call.
 *
 * Remove the avatar image for this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_avatars_call_clear_avatar (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_interface_avatars_callback_for_clear_avatar callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "ClearAvatar",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "ClearAvatar", iface,
          _tp_cli_connection_interface_avatars_invoke_callback_clear_avatar,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "ClearAvatar",
              _tp_cli_connection_interface_avatars_collect_callback_clear_avatar,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_avatars_run_state_clear_avatar;
static void
_tp_cli_connection_interface_avatars_finish_running_clear_avatar (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_avatars_run_state_clear_avatar *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_avatars_run_clear_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ClearAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Remove the avatar image for this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_avatars_run_clear_avatar (TpConnection *proxy,
    gint timeout_ms,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_avatars_run_state_clear_avatar state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "ClearAvatar", iface,
      _tp_cli_connection_interface_avatars_finish_running_clear_avatar,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "ClearAvatar",
          _tp_cli_connection_interface_avatars_collect_callback_clear_avatar,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


static inline void
tp_cli_add_signals_for_connection_interface_capabilities (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "CapabilitiesChanged",
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))),
      G_TYPE_INVALID);
}


/**
 * tp_cli_connection_interface_capabilities_signal_callback_capabilities_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_capabilities_connect_to_capabilities_changed ()
 *  was called
 * @arg_caps: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s old generic capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s new generic capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s old type specific capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s new type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CapabilitiesChanged.
 */
static void
_tp_cli_connection_interface_capabilities_collect_args_of_capabilities_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    const GPtrArray *arg_caps,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))));
  g_value_set_boxed (args->values + 0, arg_caps);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_interface_capabilities_invoke_callback_for_capabilities_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_capabilities_signal_callback_capabilities_changed callback =
      (tp_cli_connection_interface_capabilities_signal_callback_capabilities_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_interface_capabilities_connect_to_capabilities_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CapabilitiesChanged.
 *
 * Announce that there has been a change of capabilities on the         given handle, or on the connection itself if the handle is zero.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_interface_capabilities_connect_to_capabilities_changed (TpConnection *proxy,
    tp_cli_connection_interface_capabilities_signal_callback_capabilities_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES, "CapabilitiesChanged",
      expected_types,
      G_CALLBACK (_tp_cli_connection_interface_capabilities_collect_args_of_capabilities_changed),
      _tp_cli_connection_interface_capabilities_invoke_callback_for_capabilities_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_interface_capabilities_callback_for_advertise_capabilities:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of structures describing the current capabilities containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AdvertiseCapabilities method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_capabilities_collect_callback_advertise_capabilities (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GPtrArray *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))), &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_capabilities_invoke_callback_advertise_capabilities (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_capabilities_callback_for_advertise_capabilities callback = (tp_cli_connection_interface_capabilities_callback_for_advertise_capabilities) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_capabilities_call_advertise_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_add: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @in_remove: Used to pass an 'in' argument: An array of D-Bus interface names of channel types to remove
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AdvertiseCapabilities method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used by user interfaces to indicate which channel types they are able         to handle on this connection. Because these may be provided by         different client processes, this method accepts channel types to add         and remove from the set already advertised on this connection. The type         of advertised capabilities (create versus invite) is protocol-dependent         and hence cannot be set by the this method. In the case of a client         adding an already advertised channel type but with new channel type         specific flags, the connection manager should simply add the new flags         to the set of advertised capabilities.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the CapabilitiesChanged         signal will be emitted for the user&apos;s own handle (as returned by         GetSelfHandle) the by the connection manager to indicate the changes         that have been made.  This signal should also be monitored to ensure         that the set is kept accurate - for example, a client may remove         capabilities or type specific capability flags when it exits         which are still provided by another client.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_capabilities_call_advertise_capabilities (TpConnection *proxy,
    gint timeout_ms,
    const GPtrArray *in_add,
    const gchar **in_remove,
    tp_cli_connection_interface_capabilities_callback_for_advertise_capabilities callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "AdvertiseCapabilities",
          (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))), in_add,
          G_TYPE_STRV, in_remove,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "AdvertiseCapabilities", iface,
          _tp_cli_connection_interface_capabilities_invoke_callback_advertise_capabilities,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "AdvertiseCapabilities",
              _tp_cli_connection_interface_capabilities_collect_callback_advertise_capabilities,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))), in_add,
              G_TYPE_STRV, in_remove,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GPtrArray **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_capabilities_run_state_advertise_capabilities;
static void
_tp_cli_connection_interface_capabilities_finish_running_advertise_capabilities (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_capabilities_run_state_advertise_capabilities *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_capabilities_run_advertise_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_add: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @in_remove: Used to pass an 'in' argument: An array of D-Bus interface names of channel types to remove
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of structures describing the current capabilities containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AdvertiseCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used by user interfaces to indicate which channel types they are able         to handle on this connection. Because these may be provided by         different client processes, this method accepts channel types to add         and remove from the set already advertised on this connection. The type         of advertised capabilities (create versus invite) is protocol-dependent         and hence cannot be set by the this method. In the case of a client         adding an already advertised channel type but with new channel type         specific flags, the connection manager should simply add the new flags         to the set of advertised capabilities.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the CapabilitiesChanged         signal will be emitted for the user&apos;s own handle (as returned by         GetSelfHandle) the by the connection manager to indicate the changes         that have been made.  This signal should also be monitored to ensure         that the set is kept accurate - for example, a client may remove         capabilities or type specific capability flags when it exits         which are still provided by another client.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_capabilities_run_advertise_capabilities (TpConnection *proxy,
    gint timeout_ms,
    const GPtrArray *in_add,
    const gchar **in_remove,
    GPtrArray **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_capabilities_run_state_advertise_capabilities state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "AdvertiseCapabilities", iface,
      _tp_cli_connection_interface_capabilities_finish_running_advertise_capabilities,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "AdvertiseCapabilities",
          _tp_cli_connection_interface_capabilities_collect_callback_advertise_capabilities,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))), in_add,
              G_TYPE_STRV, in_remove,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_capabilities_callback_for_get_capabilities:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of generic capability flags for the type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags for the type&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetCapabilities method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_capabilities_collect_callback_get_capabilities (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GPtrArray *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))), &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_capabilities_invoke_callback_get_capabilities (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_capabilities_callback_for_get_capabilities callback = (tp_cli_connection_interface_capabilities_callback_for_get_capabilities) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_capabilities_call_get_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handles: Used to pass an 'in' argument: An array of contact handles for this connection, or zero to query capabilities available on the connection itself
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetCapabilities method call.
 *
 * Returns an array of capabilities for the given contact handles, or         the connection itself (where handle is zero).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_capabilities_call_get_capabilities (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_handles,
    tp_cli_connection_interface_capabilities_callback_for_get_capabilities callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetCapabilities",
          DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetCapabilities", iface,
          _tp_cli_connection_interface_capabilities_invoke_callback_get_capabilities,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetCapabilities",
              _tp_cli_connection_interface_capabilities_collect_callback_get_capabilities,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GPtrArray **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_capabilities_run_state_get_capabilities;
static void
_tp_cli_connection_interface_capabilities_finish_running_get_capabilities (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_capabilities_run_state_get_capabilities *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_capabilities_run_get_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_handles: Used to pass an 'in' argument: An array of contact handles for this connection, or zero to query capabilities available on the connection itself
 * @out0: Used to return an 'out' argument if %TRUE is returned: An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of generic capability flags for the type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags for the type&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns an array of capabilities for the given contact handles, or         the connection itself (where handle is zero).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_capabilities_run_get_capabilities (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_handles,
    GPtrArray **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_capabilities_run_state_get_capabilities state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetCapabilities", iface,
      _tp_cli_connection_interface_capabilities_finish_running_get_capabilities,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetCapabilities",
          _tp_cli_connection_interface_capabilities_collect_callback_get_capabilities,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


static inline void
tp_cli_add_signals_for_connection_interface_presence (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "PresenceUpdate",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))),
      G_TYPE_INVALID);
}


/**
 * tp_cli_connection_interface_presence_signal_callback_presence_update:
 * @proxy: The proxy on which tp_cli_connection_interface_presence_connect_to_presence_update ()
 *  was called
 * @arg_presence: A dictionary of contact handles mapped to a struct containing         a UNIX timestamp of the last activity time (in UTC), and         a dictionary mapping the contact&apos;s current status identifiers to           a dictionary of optional parameter names mapped to their            variant-boxed values
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PresenceUpdate.
 */
static void
_tp_cli_connection_interface_presence_collect_args_of_presence_update (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_presence,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))));
  g_value_set_boxed (args->values + 0, arg_presence);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_for_presence_update (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_signal_callback_presence_update callback =
      (tp_cli_connection_interface_presence_signal_callback_presence_update) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * tp_cli_connection_interface_presence_connect_to_presence_update:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PresenceUpdate.
 *
 * This signal should be emitted when your own presence has been changed,         or the presence of the member of any of the connection&apos;s channels has         been changed, or when the presence requested by RequestPresence is available.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
tp_cli_connection_interface_presence_connect_to_presence_update (TpConnection *proxy,
    tp_cli_connection_interface_presence_signal_callback_presence_update callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE, "PresenceUpdate",
      expected_types,
      G_CALLBACK (_tp_cli_connection_interface_presence_collect_args_of_presence_update),
      _tp_cli_connection_interface_presence_invoke_callback_for_presence_update,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * tp_cli_connection_interface_presence_callback_for_add_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AddStatus method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_add_status (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_add_status (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_add_status callback = (tp_cli_connection_interface_presence_callback_for_add_status) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_add_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_status: Used to pass an 'in' argument: The string identifier of the desired status
 * @in_parms: Used to pass an 'in' argument: A dictionary of optional parameter names mapped to their variant-boxed values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AddStatus method call.
 *
 * Request that a single presence status is published for the user, along         with any desired parameters. Changes will be indicated by PresenceUpdate         signals being emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_add_status (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_status,
    GHashTable *in_parms,
    tp_cli_connection_interface_presence_callback_for_add_status callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "AddStatus",
          G_TYPE_STRING, in_status,
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_parms,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "AddStatus", iface,
          _tp_cli_connection_interface_presence_invoke_callback_add_status,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "AddStatus",
              _tp_cli_connection_interface_presence_collect_callback_add_status,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_STRING, in_status,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_parms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_add_status;
static void
_tp_cli_connection_interface_presence_finish_running_add_status (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_add_status *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_add_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_status: Used to pass an 'in' argument: The string identifier of the desired status
 * @in_parms: Used to pass an 'in' argument: A dictionary of optional parameter names mapped to their variant-boxed values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AddStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that a single presence status is published for the user, along         with any desired parameters. Changes will be indicated by PresenceUpdate         signals being emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_add_status (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_status,
    GHashTable *in_parms,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_add_status state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "AddStatus", iface,
      _tp_cli_connection_interface_presence_finish_running_add_status,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "AddStatus",
          _tp_cli_connection_interface_presence_collect_callback_add_status,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_STRING, in_status,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_parms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_clear_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ClearStatus method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_clear_status (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_clear_status (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_clear_status callback = (tp_cli_connection_interface_presence_callback_for_clear_status) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_clear_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ClearStatus method call.
 *
 * Request that all of a user&apos;s presence statuses be removed. Be aware         that this request may simply result in the statuses being replaced by a         default available status. Changes will be indicated by PresenceUpdate         signals being emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_clear_status (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_interface_presence_callback_for_clear_status callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "ClearStatus",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "ClearStatus", iface,
          _tp_cli_connection_interface_presence_invoke_callback_clear_status,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "ClearStatus",
              _tp_cli_connection_interface_presence_collect_callback_clear_status,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_clear_status;
static void
_tp_cli_connection_interface_presence_finish_running_clear_status (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_clear_status *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_clear_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ClearStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that all of a user&apos;s presence statuses be removed. Be aware         that this request may simply result in the statuses being replaced by a         default available status. Changes will be indicated by PresenceUpdate         signals being emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_clear_status (TpConnection *proxy,
    gint timeout_ms,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_clear_status state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "ClearStatus", iface,
      _tp_cli_connection_interface_presence_finish_running_clear_status,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "ClearStatus",
          _tp_cli_connection_interface_presence_collect_callback_clear_status,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_get_presence:
 * @proxy: the proxy on which the call was made
 * @out_presence: Used to return an 'out' argument if @error is %NULL: Presence information in the same format as for the PresenceUpdate           signal
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetPresence method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_get_presence (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GHashTable *out_presence;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))), &out_presence,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out_presence);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_get_presence (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_get_presence callback = (tp_cli_connection_interface_presence_callback_for_get_presence) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_get_presence:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetPresence method call.
 *
 * Get presence previously emitted by PresenceUpdate for the given         contacts. Data is returned in the same structure as the PresenceUpdate         signal. Using this method in favour of RequestPresence has the         advantage that it will not wake up each client connected to the         PresenceUpdate signal.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_get_presence (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_presence_callback_for_get_presence callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetPresence",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetPresence", iface,
          _tp_cli_connection_interface_presence_invoke_callback_get_presence,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetPresence",
              _tp_cli_connection_interface_presence_collect_callback_get_presence,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GHashTable **out_presence;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_get_presence;
static void
_tp_cli_connection_interface_presence_finish_running_get_presence (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_get_presence *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out_presence != NULL)
    *state->out_presence = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_get_presence:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @out_presence: Used to return an 'out' argument if %TRUE is returned: Presence information in the same format as for the PresenceUpdate           signal
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetPresence and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get presence previously emitted by PresenceUpdate for the given         contacts. Data is returned in the same structure as the PresenceUpdate         signal. Using this method in favour of RequestPresence has the         advantage that it will not wake up each client connected to the         PresenceUpdate signal.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_get_presence (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    GHashTable **out_presence,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_get_presence state = {
      NULL /* loop */, error,
    out_presence,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetPresence", iface,
      _tp_cli_connection_interface_presence_finish_running_get_presence,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetPresence",
          _tp_cli_connection_interface_presence_collect_callback_get_presence,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_get_statuses:
 * @proxy: the proxy on which the call was made
 * @out0: Used to return an 'out' argument if @error is %NULL: A dictionary of string identifiers mapped to a struct for each status, containing:         &lt;ul&gt;           &lt;li&gt;a type value from one of the values above&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this status may be set on yourself&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this is an exclusive status which you may not set alongside any other&lt;/li&gt;           &lt;li&gt;a dictionary of valid optional string argument names mapped to their types&lt;/li&gt;         &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetStatuses method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_get_statuses (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GHashTable *out0;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))), &out0,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out0);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_get_statuses (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_get_statuses callback = (tp_cli_connection_interface_presence_callback_for_get_statuses) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_get_statuses:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetStatuses method call.
 *
 * Get a dictionary of the valid presence statuses for this connection.         This is only available when online because only some statuses will         be available on some servers.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_get_statuses (TpConnection *proxy,
    gint timeout_ms,
    tp_cli_connection_interface_presence_callback_for_get_statuses callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetStatuses",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetStatuses", iface,
          _tp_cli_connection_interface_presence_invoke_callback_get_statuses,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetStatuses",
              _tp_cli_connection_interface_presence_collect_callback_get_statuses,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GHashTable **out0;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_get_statuses;
static void
_tp_cli_connection_interface_presence_finish_running_get_statuses (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_get_statuses *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out0 != NULL)
    *state->out0 = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_get_statuses:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out0: Used to return an 'out' argument if %TRUE is returned: A dictionary of string identifiers mapped to a struct for each status, containing:         &lt;ul&gt;           &lt;li&gt;a type value from one of the values above&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this status may be set on yourself&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this is an exclusive status which you may not set alongside any other&lt;/li&gt;           &lt;li&gt;a dictionary of valid optional string argument names mapped to their types&lt;/li&gt;         &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetStatuses and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get a dictionary of the valid presence statuses for this connection.         This is only available when online because only some statuses will         be available on some servers.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_get_statuses (TpConnection *proxy,
    gint timeout_ms,
    GHashTable **out0,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_get_statuses state = {
      NULL /* loop */, error,
    out0,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetStatuses", iface,
      _tp_cli_connection_interface_presence_finish_running_get_statuses,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetStatuses",
          _tp_cli_connection_interface_presence_collect_callback_get_statuses,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_remove_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RemoveStatus method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_remove_status (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_remove_status (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_remove_status callback = (tp_cli_connection_interface_presence_callback_for_remove_status) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_remove_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_status: Used to pass an 'in' argument: The string identifier of the status not to publish anymore for the user
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RemoveStatus method call.
 *
 * Request that the given presence status is no longer published for the         user. Changes will be indicated by PresenceUpdate signals being         emitted. As with ClearStatus, removing a status may actually result in         it being replaced by a default available status.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_remove_status (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_status,
    tp_cli_connection_interface_presence_callback_for_remove_status callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RemoveStatus",
          G_TYPE_STRING, in_status,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RemoveStatus", iface,
          _tp_cli_connection_interface_presence_invoke_callback_remove_status,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RemoveStatus",
              _tp_cli_connection_interface_presence_collect_callback_remove_status,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_STRING, in_status,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_remove_status;
static void
_tp_cli_connection_interface_presence_finish_running_remove_status (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_remove_status *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_remove_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_status: Used to pass an 'in' argument: The string identifier of the status not to publish anymore for the user
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RemoveStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the given presence status is no longer published for the         user. Changes will be indicated by PresenceUpdate signals being         emitted. As with ClearStatus, removing a status may actually result in         it being replaced by a default available status.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_remove_status (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_status,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_remove_status state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RemoveStatus", iface,
      _tp_cli_connection_interface_presence_finish_running_remove_status,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RemoveStatus",
          _tp_cli_connection_interface_presence_collect_callback_remove_status,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_STRING, in_status,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_request_presence:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestPresence method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_request_presence (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_request_presence (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_request_presence callback = (tp_cli_connection_interface_presence_callback_for_request_presence) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_request_presence:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestPresence method call.
 *
 * Request the presence for contacts on this connection. A PresenceUpdate         signal will be emitted when they are received. This is not the same as         subscribing to the presence of a contact, which must be done using the         &apos;subscription&apos; Channel.Type.ContactList, and on some protocols presence         information may not be available unless a subscription exists.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_request_presence (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    tp_cli_connection_interface_presence_callback_for_request_presence callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestPresence",
          DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestPresence", iface,
          _tp_cli_connection_interface_presence_invoke_callback_request_presence,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestPresence",
              _tp_cli_connection_interface_presence_collect_callback_request_presence,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_request_presence;
static void
_tp_cli_connection_interface_presence_finish_running_request_presence (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_request_presence *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_request_presence:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestPresence and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the presence for contacts on this connection. A PresenceUpdate         signal will be emitted when they are received. This is not the same as         subscribing to the presence of a contact, which must be done using the         &apos;subscription&apos; Channel.Type.ContactList, and on some protocols presence         information may not be available unless a subscription exists.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_request_presence (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_contacts,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_request_presence state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "RequestPresence", iface,
      _tp_cli_connection_interface_presence_finish_running_request_presence,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "RequestPresence",
          _tp_cli_connection_interface_presence_collect_callback_request_presence,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_contacts,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_set_last_activity_time:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetLastActivityTime method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_set_last_activity_time (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_set_last_activity_time (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_set_last_activity_time callback = (tp_cli_connection_interface_presence_callback_for_set_last_activity_time) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_set_last_activity_time:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_time: Used to pass an 'in' argument: A UNIX timestamp of the user&apos;s last activity time (in UTC)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetLastActivityTime method call.
 *
 * Request that the recorded last activity time for the user be updated on         the server.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_set_last_activity_time (TpConnection *proxy,
    gint timeout_ms,
    guint in_time,
    tp_cli_connection_interface_presence_callback_for_set_last_activity_time callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetLastActivityTime",
          G_TYPE_UINT, in_time,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetLastActivityTime", iface,
          _tp_cli_connection_interface_presence_invoke_callback_set_last_activity_time,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetLastActivityTime",
              _tp_cli_connection_interface_presence_collect_callback_set_last_activity_time,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_time,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_set_last_activity_time;
static void
_tp_cli_connection_interface_presence_finish_running_set_last_activity_time (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_set_last_activity_time *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_set_last_activity_time:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_time: Used to pass an 'in' argument: A UNIX timestamp of the user&apos;s last activity time (in UTC)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetLastActivityTime and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the recorded last activity time for the user be updated on         the server.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_set_last_activity_time (TpConnection *proxy,
    gint timeout_ms,
    guint in_time,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_set_last_activity_time state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "SetLastActivityTime", iface,
      _tp_cli_connection_interface_presence_finish_running_set_last_activity_time,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "SetLastActivityTime",
          _tp_cli_connection_interface_presence_collect_callback_set_last_activity_time,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_UINT, in_time,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/**
 * tp_cli_connection_interface_presence_callback_for_set_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetStatus method call
 * succeeds or fails.
 */
static void
_tp_cli_connection_interface_presence_collect_callback_set_status (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_tp_cli_connection_interface_presence_invoke_callback_set_status (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  tp_cli_connection_interface_presence_callback_for_set_status callback = (tp_cli_connection_interface_presence_callback_for_set_status) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_call_set_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_statuses: Used to pass an 'in' argument: A dictionary mapping status identifiers to dictionaries, which           map optional parameter names to their variant-boxed values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetStatus method call.
 *
 * Request that the user&apos;s presence be changed to the given statuses and         desired parameters. Changes will be reflected by PresenceUpdate         signals being emitted. On certain protocols, this method may be         called on a newly-created connection which is still in the         DISCONNECTED state, and will sign on with the requested status.         If the requested status is not available after signing on,         NotAvailable will be returned and the connection will remain         offline, or if the protocol does not support signing on with         a certain status, Disconnected will be returned.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
tp_cli_connection_interface_presence_call_set_status (TpConnection *proxy,
    gint timeout_ms,
    GHashTable *in_statuses,
    tp_cli_connection_interface_presence_callback_for_set_status callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetStatus",
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), in_statuses,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetStatus", iface,
          _tp_cli_connection_interface_presence_invoke_callback_set_status,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetStatus",
              _tp_cli_connection_interface_presence_collect_callback_set_status,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), in_statuses,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    gboolean success:1;
    gboolean completed:1;
} _tp_cli_connection_interface_presence_run_state_set_status;
static void
_tp_cli_connection_interface_presence_finish_running_set_status (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _tp_cli_connection_interface_presence_run_state_set_status *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * tp_cli_connection_interface_presence_run_set_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_statuses: Used to pass an 'in' argument: A dictionary mapping status identifiers to dictionaries, which           map optional parameter names to their variant-boxed values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the user&apos;s presence be changed to the given statuses and         desired parameters. Changes will be reflected by PresenceUpdate         signals being emitted. On certain protocols, this method may be         called on a newly-created connection which is still in the         DISCONNECTED state, and will sign on with the requested status.         If the requested status is not available after signing on,         NotAvailable will be returned and the connection will remain         offline, or if the protocol does not support signing on with         a certain status, Disconnected will be returned.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */
gboolean
tp_cli_connection_interface_presence_run_set_status (TpConnection *proxy,
    gint timeout_ms,
    GHashTable *in_statuses,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE;
  TpProxyPendingCall *pc;
  _tp_cli_connection_interface_presence_run_state_set_status state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "SetStatus", iface,
      _tp_cli_connection_interface_presence_finish_running_set_status,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "SetStatus",
          _tp_cli_connection_interface_presence_collect_callback_set_status,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), in_statuses,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/*
 * tp_cli_connection_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
tp_cli_connection_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == TP_IFACE_QUARK_CONNECTION)
    tp_cli_add_signals_for_connection (proxy);
  if (quark == TP_IFACE_QUARK_CONNECTION_INTERFACE_ALIASING)
    tp_cli_add_signals_for_connection_interface_aliasing (proxy);
  if (quark == TP_IFACE_QUARK_CONNECTION_INTERFACE_AVATARS)
    tp_cli_add_signals_for_connection_interface_avatars (proxy);
  if (quark == TP_IFACE_QUARK_CONNECTION_INTERFACE_CAPABILITIES)
    tp_cli_add_signals_for_connection_interface_capabilities (proxy);
  if (quark == TP_IFACE_QUARK_CONNECTION_INTERFACE_PRESENCE)
    tp_cli_add_signals_for_connection_interface_presence (proxy);
}
